function [neighbors] = find_neighbors_test(vertex,nlist,nhood)
%This little function is used to find all the points in a neighborhood
%around a central vertex
%Synatax:   [neighbors] = find_neighbors(vertex,nlist,nhood);
%Input:     vertex = the point as defined by x,y,z around which the search
%                   is conducted
%           nlist = a x by 3 list of points that represent all the points
%                   around the vertex.
%           nhood = defines a cube 2xnhood around the vertex by whihc all
%                   the points in nlist will be filtered.
%
%Output:    neighbors = A list of all the points surrounding the vertex
%                       within the neighborhood defined by nhood.

%parse data & error check
if nargin<3     %nhood = default
    nhood = 10;
end
if size(nlist,2)==2     %nlist must have a third column for z
    nlist_tmp = zeros(size(nlist,1),1);     %z = 0 as a default
    nlist = cat(2,nlist,nlist_tmp);
elseif size(nlist,2)~=3 %non standard input.
    error('the list of points you enter must be of the format [x;y;z]');
end
if size(vertex,2)==2     %same for vertex, must have a third column for z
    vertex = [vertex 0];     %z = 0 as a default
elseif size(vertex,2)~=3 %non standard input.
    error('the vertex you enter must be of the format [x;y;z]');
end


%Will you be my neighbor?
%lets look for x first
[x,y] = find(nlist(:,1)<=vertex(1,1)+nhood & nlist(:,1)>=vertex(1,1)-nhood);
nlist_tmp = nlist(x,:);     %first cut
%lets look for y next
[x,y] = find(nlist_tmp(:,2)<=vertex(1,2)+nhood & nlist_tmp(:,2)>=vertex(1,2)-nhood);
nlist_tmp = nlist_tmp(x,:); %second cut
%lets look at z now
[x,y] = find(nlist_tmp(:,3)<=vertex(1,3)+nhood & nlist_tmp(:,3)>=vertex(1,3)-nhood);
neighbors = nlist_tmp(x,:); %finalists